/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation;

import com.jgoodies.animation.AbstractAnimation;
import com.jgoodies.animation.Animation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class Animations {
    private Animations() {
    }

    public static Animation offset(long beginTime, Animation animation) {
        return new OffsetAnimation(beginTime, animation);
    }

    public static Animation parallel(List animations) {
        return new ParallelAnimation(animations);
    }

    public static Animation parallel(Animation animation1, Animation animation2) {
        LinkedList<Animation> list = new LinkedList<Animation>();
        list.add(animation1);
        list.add(animation2);
        return Animations.parallel(list);
    }

    public static Animation pause(long duration) {
        return new PauseAnimation(duration);
    }

    public static Animation repeat(float repeatCount, Animation animation) {
        long duration = (long)((float)animation.duration() * repeatCount);
        return new RepeatedAnimation(duration, animation);
    }

    public static Animation reverse(Animation animation) {
        return new ReversedAnimation(animation);
    }

    public static Animation sequential(List animations) {
        return new SequencedAnimation(animations);
    }

    public static Animation sequential(Animation[] animations) {
        return Animations.sequential(Arrays.asList(animations));
    }

    public static Animation sequential(Animation first, Animation second) {
        LinkedList<Animation> sequence = new LinkedList<Animation>();
        sequence.add(first);
        sequence.add(second);
        return Animations.sequential(sequence);
    }

    private static final class SequencedAnimation
    extends AbstractAnimation {
        private final List animations;

        private SequencedAnimation(List animations) {
            super(SequencedAnimation.cumulatedDuration(animations), true);
            this.animations = Collections.unmodifiableList(animations);
            if (this.animations.isEmpty()) {
                throw new IllegalArgumentException("The list of animations must not be empty.");
            }
        }

        private static long cumulatedDuration(List animations) {
            long cumulatedDuration = 0L;
            Iterator i = animations.iterator();
            while (i.hasNext()) {
                Animation animation = (Animation)i.next();
                cumulatedDuration += animation.duration();
            }
            return cumulatedDuration;
        }

        protected void applyEffect(long time) {
            long startTime = 0L;
            Iterator i = this.animations.iterator();
            while (i.hasNext()) {
                Animation animation = (Animation)i.next();
                long relativeTime = time - startTime;
                if (relativeTime > 0L) {
                    animation.animate(relativeTime);
                }
                startTime += animation.duration();
            }
        }
    }

    private static final class ReversedAnimation
    extends AbstractAnimation {
        private final Animation animation;

        private ReversedAnimation(Animation animation) {
            super(animation.duration(), true);
            this.animation = animation;
        }

        protected void applyEffect(long time) {
            long reversedTime = this.duration() - time;
            if (reversedTime < 0L) {
                throw new IllegalArgumentException("The time is outside the valid time interval.");
            }
            this.animation.animate(reversedTime);
        }
    }

    private static final class RepeatedAnimation
    extends AbstractAnimation {
        private final Animation animation;
        private final long simpleDuration;

        private RepeatedAnimation(long duration, Animation animation) {
            super(duration, true);
            this.animation = animation;
            this.simpleDuration = animation.duration();
        }

        protected void applyEffect(long time) {
            this.animation.animate(time % this.simpleDuration);
        }
    }

    private static final class PauseAnimation
    extends AbstractAnimation {
        PauseAnimation(long duration) {
            super(duration, true);
        }

        protected void applyEffect(long time) {
        }
    }

    private static final class ParallelAnimation
    extends AbstractAnimation {
        private final List animations;

        private ParallelAnimation(List animations) {
            super(ParallelAnimation.maxDuration(animations), true);
            this.animations = animations;
        }

        private static long maxDuration(List animations) {
            long maxDuration = 0L;
            Iterator i = animations.iterator();
            while (i.hasNext()) {
                Animation animation = (Animation)i.next();
                long duration = animation.duration();
                if (duration <= maxDuration) continue;
                maxDuration = duration;
            }
            return maxDuration;
        }

        protected void applyEffect(long time) {
            Iterator i = this.animations.iterator();
            while (i.hasNext()) {
                Animation animation = (Animation)i.next();
                animation.animate(time);
            }
        }
    }

    public static abstract class OneTimeAnimation
    extends AbstractAnimation {
        private boolean effectApplied = false;

        public OneTimeAnimation() {
            super(0L, true);
        }

        public void animate(long time) {
            if (this.effectApplied) {
                return;
            }
            this.fireAnimationStarted(time);
            this.applyEffect(time);
            this.fireAnimationStopped(time);
            this.effectApplied = true;
        }
    }

    private static final class OffsetAnimation
    extends AbstractAnimation {
        private final Animation animation;
        private final long beginTime;

        private OffsetAnimation(long beginTime, Animation animation) {
            super(beginTime + animation.duration(), true);
            this.animation = animation;
            this.beginTime = beginTime;
        }

        protected void applyEffect(long time) {
            long relativeTime = time - this.beginTime;
            if (relativeTime >= 0L) {
                this.animation.animate(relativeTime);
            }
        }
    }
}

